use strict;

#my @interfaceList = ("IJMIMDelegete", "IJMIMCallback", "JMDependence", "IJMCommonEventCallback", "ICommonDependenciesDelegate", "JMLogger", "CSSOSink", "JMMeetingMgr", "JMMeetingMgrHandler", "IWbxMeetingAccountObserve", "IWbxMeetingAccountMgr", "IMeetingAccountInfoDelegate", "IMeetingAccountInfoCallback", "IInstantMeetingEvent", "IInstantMeetingMgr", "IDSMgr", "IDSMgrEvent");

my @interfaceList = ("IJMIMCallback", "IJMCommonEventCallback", "JMMeetingMgr", "IWbxMeetingAccountMgr", "IMeetingAccountInfoCallback", "IInstantMeetingMgr", "IDSMgr");

my @callbackList = ("IJMIMDelegete", "ICommonDependenciesDelegate", "JMLogger", "JMMeetingMgrHandler", "IWbxMeetingAccountObserve",  "IMeetingAccountInfoDelegate", "IInstantMeetingEvent", "IDSMgrEvent", "JMProxy");

my $g_indent;
my $g_header_dir = $ENV{"JABBERMEETINGIMPORT"} eq "" ? "./include/" : "$ENV{\"JABBERMEETINGIMPORT\"}/include/";
my @g_headerFiles;
my $g_impl_h_fh;
my $g_impl_cpp_fh;
my $g_typedef_fh;

readAllHeaderFiles();


my $impl_h_file = "meeting_sdk_impl.h";
my $impl_cpp_file = "meeting_sdk_impl.cpp";
my $csdk_h_file = "jabber_meeting_csdk.h";

open ($g_impl_h_fh, ">$impl_h_file");
open ($g_impl_cpp_fh, ">$impl_cpp_file");
open ($g_typedef_fh, ">$csdk_h_file");

buildImplHHeader();

buildTypedefHeader();

buildImplCPPHeader();

for my$interface (@interfaceList) {
  gen_proxy_define($interface, 0);
}

for my$callback (@callbackList) {
  gen_proxy_define($callback, 1);
}

close $g_impl_h_fh;
close $g_impl_cpp_fh;
close $g_typedef_fh;


sub printImplHFile {
  my $line = shift;
  print $g_impl_h_fh "$g_indent$line\n";
}

sub readAllHeaderFiles {
  opendir(DH, $g_header_dir);
  @g_headerFiles = readdir(DH);
  closedir(DH);
}

sub checkReturnType {
  my $retType = shift;
  $retType = "HRESULT" if ($retType eq "mstdapi");
  $retType = "HRESULT" if ($retType eq "HRESULT __stdcall");
  return $retType;
}

sub buildImplHHeader {
  print $g_impl_h_fh "#pragma once\n\n";
  print $g_impl_h_fh "#include \"../sdkIncludes.h\"\n";
  print $g_impl_h_fh "#include \"$csdk_h_file\"\n\n";
}

sub buildTypedefHeader {
  print $g_typedef_fh "#pragma once\n";
  print $g_typedef_fh "#include \"../sdkIncludes.h\"\n";
  print $g_typedef_fh "\ntypedef HMODULE JMHandle;\n";
  print $g_typedef_fh "typedef long JMResult;\n\n";
  print $g_typedef_fh "/**\n";
  print $g_typedef_fh "*\@brief defined of the result for HMResult\n";
  print $g_typedef_fh "*/\n";
  print $g_typedef_fh "#define JMSucceed ((JMResult)1)\n";
  print $g_typedef_fh "#define JMFailed ((JMResult)0)\n\n";
  
  my $exportStr = gen_export_func();
  print $g_typedef_fh "$exportStr\n";
}

sub buildImplCPPHeader {
  print $g_impl_cpp_fh "#include \"$impl_h_file\"\n";
  print $g_impl_cpp_fh "#include <assert.h>\n\n";
  print $g_impl_cpp_fh "typedef JMResult (*PFEventCallbackSet)(const char *pEventName, void *pfFuncCallBack);\n";
  print $g_impl_cpp_fh "typedef JMResult (*PFFunctionGet)(const char *pFunctionName, void **pfFunc);\n\n";
}

sub gen_proxy_define {
  my $iName = shift;
  my $bCallBack = shift;
  my $file = getInterfaceDefineFile($iName);
  my @funcCollector;
  my %funcChecker;
  
  my $iSuffix = "Impl";
  $iSuffix = "Wrapper" if ($bCallBack == 1);

  if ($file eq "") {
    print "Error: Cannot find header file for interface: $iName.\n";
    return;
  }

  open(FH, $g_header_dir.$file) or die "cannot open file $file\n";

  my $processed = 0;
  while(my $line = <FH>) {

	if($line =~ /^(\s*)class\s+$iName\s*$/) {
	  $processed = 1;
	  $g_indent = $1;

	  print "$file: ${iName} -> ${iName}$iSuffix\n";
	  if($bCallBack != 1) {
	    printImplHFile "class ${iName}$iSuffix : public $iName";
	  } else {
	    printImplHFile "class ${iName}$iSuffix";
	  }

	  print $g_typedef_fh "\n/***\n";
	  print $g_typedef_fh "*\t${iName}$iSuffix\n";
	  print $g_typedef_fh "***/\n";
	  
	  print $g_impl_cpp_fh "\n/***\n";
	  print $g_impl_cpp_fh "*\t${iName}$iSuffix\n";
	  print $g_impl_cpp_fh "***/\n";
	  
	  my ($cpp_strings, $def_strings, $typedef_strings);
	  
	  while(my $innerLine = <FH>) {
		
		next if $innerLine =~ /^\s*$/;

		if($innerLine =~ /^\s*{/) {
		  print $g_impl_h_fh $innerLine;
		  
		  printImplHFile "public:";
		  if($bCallBack != 1) {
		    printImplHFile "\t${iName}$iSuffix();";
		    printImplHFile "\t~${iName}$iSuffix();\n";

		    printImplHFile "\tvoid FuncInit(JMHandle libHandle);";
		    printImplHFile "\tvoid FuncUnInit();\n";
		  } else {
		    printImplHFile "\tvoid SetHandler($iName* p$iName);";
			printImplHFile "\tvoid FuncInit(JMHandle libHandle);";
		  }
		}
		elsif($innerLine =~ /^\s*virtual\s+(.*)\s+(\S+)\((.*)\)\s*=\s*0\s*;(.*)$/) {
		  my($retType, $funcName, $org_params, $comments) = ($1, $2, $3, $4);

		  if(defined($funcChecker{$funcName})) {
		    print "WARNING: Method $funcName is duplicate!!!";
		  } else {
		    $funcChecker{$funcName} = 1;
			push(@funcCollector, $funcName);
		  }

		  my $p1 = $bCallBack ? "static" : "virtual";
		  printImplHFile "\t$p1 $retType $funcName($org_params);$comments\n";
		  
		  $retType = checkReturnType($retType);
		  $cpp_strings .= "$retType ${iName}$iSuffix\::$funcName($org_params)\n";
		  $cpp_strings .= "{\n";

		  my $params = $org_params;
		  $params = $params.","; # add an ending ',' for following batch processing
		  $params =~ s/[^,]+\s[&*]?(\S+)\s*,/$1,/g;
		  chop($params); # remove the last added ","
		  $params =~ s/,/, /g;

		  $def_strings .= "#define JMSDK_${iName}_$funcName \"JMSDK_${iName}_$funcName\"\n\n";

		  if ($bCallBack != 1) {
		    my $innerCall = "JMResult jmResult = (*mpf$funcName)(";
		    $innerCall .= "$params" if $params ne "";

		    if ($retType eq "void") {
		      $cpp_strings .= "\t$innerCall);\n";
			  $cpp_strings .= "\tassert(jmResult == JMSucceed);\n";

			  $typedef_strings .= "typedef JMResult (*pf_jmsdk_${iName}_$funcName)($org_params);\n\n";
		    } else {
		      $cpp_strings .= "\t$retType ret;\n";
			  if ($params eq "") {
			    $cpp_strings .= "\t${innerCall}ret);\n";
			  } else {
		        $cpp_strings .= "\t$innerCall, ret);\n";
			  }
			  $cpp_strings .= "\tassert(jmResult == JMSucceed);\n";
			  $cpp_strings .= "\treturn ret;\n";
			
			  my $p = "$org_params, ";
			  $p = "" if $org_params eq "";
			  $typedef_strings .= "typedef JMResult (*pf_jmsdk_${iName}_$funcName)($p$retType &ret);\n\n";
		    }
		  } else {
		    $cpp_strings .= "\tif(m_p$iName != NULL)\n";
			$cpp_strings .= "\t{\n";
			my $p3 = $retType eq "void" ? "" : "return ";
			$cpp_strings .= "\t\t${p3}m_p$iName->$funcName($params);\n\t}\n";
			
			my $retstr;
			if ($retType eq "BOOL") {
			  $retstr = "\treturn FALSE;\n";
			} elsif ($retType eq "bool") {
			  $retstr = "\treturn false;\n";
			} elsif ($retType eq "wstring") {
			  $retstr = "\treturn L\"\";\n";
			} elsif ($retType eq "HRESULT") {
			  $retstr = "\treturn 0;\n";
			}
			$cpp_strings .= $retstr;
			
			$typedef_strings .= "typedef $retType (*pf_jmsdk_${iName}_$funcName)($org_params);\n\n";
		  }

		  $cpp_strings .= "}\n\n";

		}elsif($innerLine =~/\};/) {
		  if ($bCallBack != 1) {
		    printImplHFile "public:";
		    for my $func(@funcCollector) {
		      printImplHFile "\tpf_jmsdk_${iName}_$func mpf$func;";
		    }

			my $cppInitString = buildImplFuncInit($iName, \@funcCollector);
			$cpp_strings = $cppInitString.$cpp_strings;
		  } else {
		    printImplHFile "private:";
			printImplHFile "\tstatic $iName* m_p$iName;";

			my $cppInitString = buildCallbackFuncInit($iName, \@funcCollector);
			$cpp_strings = $cppInitString.$cpp_strings;
		  }
		  print $g_impl_h_fh "$innerLine\n";

		  print $g_impl_cpp_fh $cpp_strings;
		  
		  print $g_typedef_fh $def_strings;
		  print $g_typedef_fh $typedef_strings;

		  return;
		} else {
		  print $g_impl_h_fh "$innerLine";
		}
	  }
	  
	}
  }
  close FH;
  
  if($processed == 0) {
    print "failed to process: $iName, $file\n";
  }
}

sub buildCallbackFuncInit {
  my $name = shift;
  my $funcList = shift;
  
  my $iSuffix = "Wrapper";
  
  # static member
  my $ret = "$name* $name$iSuffix\::m_p$name = NULL;\n";
  
  # SetHandler
  $ret .= "void ${name}$iSuffix\::SetHandler($name* p$name)\n{\n";
  $ret .= "\tm_p$name = p$name;\n";
  $ret .= "}\n\n";
  
  # FuncInit method
  $ret .= "void ${name}$iSuffix\::FuncInit(JMHandle libHandle)\n{\n";
  $ret .= "\tassert(libHandle != 0);\n\n";
  
  $ret .= "\tvoid *pFunc = (void*)GetProcAddress(libHandle, \"jmevent_callback_set\");\n";
  $ret .= "\tassert(pFunc != NULL);\n";
  $ret .= "\tPFEventCallbackSet pfEventCallbackSet = (PFEventCallbackSet)pFunc;\n\n";
  
  $ret .= "\tJMResult jmResult;\n";
  for my $func(@$funcList) {
    $ret .= "\tjmResult = (*pfEventCallbackSet)(JMSDK_${name}_$func, (void*)&${name}$iSuffix\::$func);\n";
  }
  $ret .= "}\n\n";
  
  return $ret;
}

sub buildImplFuncInit {
  my $name = shift;
  my $funcList = shift;
  
  # Constructor
  my $ret = "${name}Impl\::${name}Impl()\n{\n";
  for my $func(@$funcList) {
    $ret .= "\tmpf$func = NULL;\n";
  }
  $ret .= "}\n\n";
  
  # Destructor
  $ret .= "${name}Impl\::~${name}Impl()\n{\n}\n\n";
  
  # FuncInit
  $ret .= "void ${name}Impl\::FuncInit(JMHandle libHandle)\n{\n";
  $ret .= "\tassert(libHandle != 0);\n\n";
  
  $ret .= "\tvoid *pFunc = (void*)GetProcAddress(libHandle, \"jmsdk_function_get\");\n";
  $ret .= "\tassert(pFunc != NULL);\n";
  $ret .= "\tPFFunctionGet pfFunctionGet = (PFFunctionGet)pFunc;\n\n";
  
  $ret .= "\tJMResult jmResult;\n";
  for my $func(@$funcList) {
    $ret .= "\tjmResult = (*pfFunctionGet)(JMSDK_${name}_$func, (void**)&mpf$func);\n";
  }
  $ret .= "}\n\n";
  
  # FuncUninit
  $ret .= "void ${name}Impl\::FuncUnInit()\n{\n";
  for my $func(@$funcList) {
    $ret .= "\tmpf$func = NULL;\n";
  }
  $ret .= "}\n\n";
  
  return $ret;
}

sub getInterfaceDefineFile{
  my $iName = shift;
  
  for my $file (@g_headerFiles) {
    # skip . and ..
    next if($file =~ /^\.$/);
    next if($file =~ /^\.\.$/);
	
	open(FILE, $g_header_dir.$file);
	if (grep{/^\s*class\s+$iName\s*$/} <FILE>) {
	  close FILE;
	  return $file;
	} else {
	  close FILE;
	}
  }
  
  return "";
}


sub gen_export_func {
  my $retString = << "EXPORT_FUNC"
  namespace JabberMeeting {
#ifdef WIN32
#ifdef JABBERMEETINGSERVICE_EXPORTS
#define JABBERMEETING_API __declspec(dllexport)
#else
#define JABBERMEETING_API __declspec(dllimport)
#endif
#endif

	extern "C"
	{
		JABBERMEETING_API JMResult jmevent_callback_set(const char *pEventName, void *pfFuncCallBack);
		JABBERMEETING_API JMResult jmsdk_function_get(const char *pFunctionName, void **pfRemotFunc);
	};

}
EXPORT_FUNC
}
